require "API/DST_API"
require "API/DST_Helpers"

local DST = rawget(_G, "DST") or {}
local ST  = DST and DST.SkillTooltips
if not ST then return end

local KEY = "Carpentry"

ST.addContributor(KEY, function(ctx)
    ctx.addHeader(ST.getText("IGUI_DST_Core_hdr"))

    -- Wood build HP total at this level (50 * level, +100 if Handy)
    local lvl = ctx.getLevel()
    local woodHP = 50 * lvl
    local isHandy = (ctx.player and ctx.player:HasTrait("Handy")) or false

    if woodHP > 0 then
        if isHandy then
            woodHP = woodHP + 100
            ctx.add(
                ST.getText("IGUI_DST_Carpentry_val_WoodHP", tostring(woodHP))
                .. " (" .. ST.getText("UI_trait_Handy") .. ")"
            )
        else
            ctx.add(ST.getText("IGUI_DST_Carpentry_val_WoodHP", tostring(woodHP)))
        end
    end

    --- Compute wood plank barricade HP for a given Carpentry level.
    -- Inputs : level (0..10)
    -- Output : integer HP for ONE wooden plank
    -- Temporary Hack (Build 42.x) — reason: match commonly observed values without a lookup table.
    --  L0..L1: 1000
    --  L2..L8: 1100,1140,1180,1220,1260,1300,1340
    --  L9:     1400
    --  L10:    1500
    local function calcBarricadePlankHP(level)
        if level <= 1 then return 1000 end
        if level <= 8 then
            return 1000 + 100 + (level - 2) * 40
        elseif level == 9 then
            return 1400
        else -- level == 10
            return 1500
        end
    end

    local barricadeHP = calcBarricadePlankHP(lvl)
    ctx.add(ST.getText("IGUI_DST_Carpentry_val_BarricadeHP", tostring(barricadeHP)))

    -- If you keep a formula/info helper line, re-enable it here:
    -- ctx.add(ST.getText("IGUI_DST_Carpentry_info_Barricade"))
end)

ST.addAutoLearnRecipes(KEY)
ST.addUnlockCraftRecipes(KEY)
ST.addUnlockBuildRecipes(KEY)
